'use client'

import { useState } from 'react'
import { Metadata } from 'next'

// Note: Since this is a client component, we'll need to handle metadata differently
// For now, we'll add it as a comment for when we convert parts to server components

/*
export const metadata: Metadata = {
  title: 'Auto Insurance FAQ - Common Questions & Expert Answers | SecureAuto Hub',
  description: 'Find answers to frequently asked questions about auto insurance coverage, claims, pricing, and more. Expert guidance from SecureAuto Hub professionals.',
  keywords: [
    'auto insurance FAQ',
    'car insurance questions',
    'insurance coverage explained',
    'auto insurance help',
    'insurance claims process'
  ],
}
*/

export default function FAQPage() {
  const [openItems, setOpenItems] = useState<number[]>([])

  const faqData = [
    {
      question: 'What types of auto insurance coverage do I need?',
      answer: 'The basic coverage types include liability (required in most states), collision, comprehensive, uninsured/underinsured motorist, and personal injury protection (PIP). The specific requirements vary by state.'
    },
    {
      question: 'How are auto insurance premiums calculated?',
      answer: 'Insurance premiums are based on multiple factors including your age, driving record, credit score, location, vehicle type and value, coverage limits, deductibles, and annual mileage.'
    },
    {
      question: 'What should I do immediately after an accident?',
      answer: 'First, ensure everyone\'s safety and call 911 if needed. Then: exchange information with other drivers, take photos, get witness contact info, file a police report if required, and contact your insurance company.'
    },
    {
      question: 'How can I lower my auto insurance premiums?',
      answer: 'You can lower premiums by: maintaining a clean driving record, increasing deductibles, bundling policies, taking advantage of discounts, driving less, choosing a safer vehicle, and shopping around for better rates.'
    }
  ]

  const toggleItem = (index: number) => {
    setOpenItems(prev =>
      prev.includes(index)
        ? prev.filter(i => i !== index)
        : [...prev, index]
    )
  }

  return (
    <div className="min-h-screen bg-gray-50">
      <div className="max-w-4xl mx-auto px-4 py-16">
        <div className="text-center mb-12">
          <h1 className="text-4xl font-bold text-gray-900 mb-4">
            Frequently Asked Questions
          </h1>
          <p className="text-xl text-gray-600">
            Find answers to common questions about auto insurance
          </p>
        </div>

        <div className="space-y-4">
          {faqData.map((item, index) => (
            <div key={index} className="bg-white rounded-lg shadow-md overflow-hidden">
              <button
                onClick={() => toggleItem(index)}
                className="w-full px-6 py-4 text-left flex justify-between items-center hover:bg-gray-50"
              >
                <span className="font-semibold text-gray-900">
                  {item.question}
                </span>
                <svg
                  className={`w-5 h-5 text-gray-500 transform transition-transform ${
                    openItems.includes(index) ? 'rotate-180' : ''
                  }`}
                  fill="none"
                  stroke="currentColor"
                  viewBox="0 0 24 24"
                >
                  <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M19 9l-7 7-7-7" />
                </svg>
              </button>
              {openItems.includes(index) && (
                <div className="px-6 pb-4">
                  <div className="border-t pt-4">
                    <p className="text-gray-700 leading-relaxed">
                      {item.answer}
                    </p>
                  </div>
                </div>
              )}
            </div>
          ))}
        </div>
      </div>
    </div>
  )
}
